Scriptname MarbleMagicChainHitScript extends activemagiceffect  

import Utility

Int indexSound
Int indexHit

Float Damage

Spell Property  MarbleSpellChainHit Auto

Sound Property MarbleSoundChainHit01  Auto
Sound Property MarbleSoundChainHit02  Auto

VisualEffect Property MarbleVisualChainHit01 Auto
VisualEffect Property MarbleVisualChainHit02 Auto
VisualEffect Property MarbleVisualChainHit03 Auto
VisualEffect Property MarbleVisualChainHit04 Auto

Faction Property faction01  Auto  

GlobalVariable Property MarbleDamageRate  Auto
GlobalVariable Property MarblePhantasmTrigger Auto

Event OnEffectStart(Actor Target, Actor Caster)

	Actor PlayerActor = Game.GetPlayer()

	if !Target.IsInFaction(faction01) && !Target.IsDead()

		if !Target.IsHostileToActor(PlayerActor)
			return
		endif

		indexSound = RandomInt(1,6)

		if indexSound == 1
			MarbleSoundChainHit01.play(Caster)  
		elseif indexSound == 2
			MarbleSoundChainHit02.play(Caster)  
		else

		endif

		Damage =  Caster.getav("Alteration") as float
		Damage *= 0.1
		Damage *= MarbleDamageRate.getValue()

		Target.DamageAv("Health", Damage)

		indexHit = RandomInt(1,4)

		if indexHit == 1
			MarbleVisualChainHit01.play(Target,0.15)
		elseif indexHit == 2
			MarbleVisualChainHit02.play(Target,0.15)
		elseif indexHit == 3
			MarbleVisualChainHit03.play(Target,0.15)
		else
			MarbleVisualChainHit04.play(Target,0.15)
		endif

		Target.StartCombat(Caster)

	endif

EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)

;	if MarblePhantasmTrigger.getValue() == 1
;		MarbleSpellChainHit.Cast(Caster)
;	endif

EndEvent
